﻿<%@ Page Language="c#" CodePage="1200" %>

<%@ Register TagPrefix="ea" Namespace="Soneta.Web" Assembly="Soneta.Web" %>
<%@ Register TagPrefix="cc1" Namespace="Soneta.Core.Web" Assembly="Soneta.Core.Web" %>

<%@ Import Namespace="System.ComponentModel" %>
<%@ Import Namespace="System.Collections.Generic" %>
<%@ Import Namespace="System.Diagnostics" %>
<%@ Import Namespace="Soneta.CRM" %>
<%@ Import Namespace="Soneta.Tools" %>
<%@ Import Namespace="Soneta.Core" %>
<%@ Import Namespace="Soneta.Types" %>
<%@ Import Namespace="Soneta.Business" %>
<%@ Import Namespace="Soneta.Ksiega" %>
<%@ Import Namespace="Soneta.Kasa" %>
<%@ Import Namespace="Soneta.Waluty" %>
<%@ Import Namespace="Soneta.Kasa.Forms" %>


<!DOCTYPE HTML PUBLIC "-//W3C//DTD HTML 4.0 Transitional//EN" >
<html>
<head>
	<title>Struktura wiekowa naleznosci - zestawienie</title>
	<script runat="server">
	
		//
		// KONFIGURACJA RAPORTU
		//

		// 
		// - nazwa cechy kontrahenta        
		// - nazwa słownika 
		// - etykieta wyświetlana podczas pytania o wartość pola
		// 

		private const String wgWartościCechy = "Kategoria";
		private const String wgWartościDictionary = "F.Kategoria";
		private const String wgWartościLabel = "Kategoria";

		//
		// Podział na strefy
		// W przypadku modyfikacji w tablicy okresy należy wpisać kolejne wartości graniczne	
		//
		private static readonly int[] okresy = new int[] { 30, 60, 90, 180, 365 };


		//
		// PARAMETERS
		//

		public enum Zakres
		{ Razem, Kontrahenci, Pracownicy, Urzędy }

		public enum TypDokumentow
		{ Zobowiązania, Należności, PerSaldo }

		public enum TypRozliczen
		{
            [Caption("wg rozrachunków")]
            Kasowe,
            [Caption("wg kont")]
            Księgowe
        }


		public class PrnParams : Soneta.Business.OkresContext
		{
			private FromTo okresKS;
			private Zakres zakres = Zakres.Kontrahenci;
			private TypRozliczen typRozliczen = TypRozliczen.Kasowe;
			private IPodmiotKasowy odk;
			private IPodmiotKasowy dok;
			private String wartośćCechy = String.Empty;
			private TypDokumentow dokumenty = TypDokumentow.Należności;
			private RodzajDokumentów rodzaj = RodzajDokumentów.Razem;
			private Boolean wgWartosciPLNHist;
			private Waluta waluta;
			private String aktualneKonto = String.Empty;
		    private Soneta.Kasa.OddzialParams oParams;


			public PrnParams(Context context)
				: base(context)
			{
				this.waluta = WalutyModule.GetInstance(this).Waluty.PLN;
				this.Okres = FromTo.All;
				this.okresKS = FromTo.All;
                this.oParams=new Soneta.Kasa.OddzialParams(context);
			}


			protected override void Accept()
			{
				Session.Verifiers.Add(new WeryfikatorWaluty(this));
				base.Accept();
			}


			[Priority(10)]
			public override Date Aktualny
			{
				get { return base.Aktualny; }
				set { base.Aktualny = value; }
			}


			[Priority(15)]
			[Caption("Typ rozliczeń")]
			public TypRozliczen TypRozliczen
			{
				get { return typRozliczen; }
				set
				{
					typRozliczen = value;
					OnChanged();
				}
			}


			[Priority(20)]
			public override FromTo Okres
			{
				get { return base.Okres; }
				set
				{
					base.Okres = value != FromTo.Empty ? value : FromTo.All;
					OnChanged();
				}
			}


			[Priority(30)]
			[Caption("Okres księgowy")]
			public FromTo OkresKS
			{
				get { return okresKS; }
				set
				{
					okresKS = value != FromTo.Empty ? value : FromTo.All;
					OnChanged();
				}
			}


			[Priority(140)]
			public Zakres Zakres
			{
				get { return zakres; }
				set
				{
					if ((zakres = value) != Zakres.Kontrahenci)
						wartośćCechy = String.Empty;
					OnChanged();
				}
			}


			[Priority(150)]
			[Caption("Od kontrahenta")]
			public IPodmiotKasowy Od
			{
				get { return odk; }
				set
				{
					odk = value;
					OnChanged();
				}
			}


			[Priority(160)]
			[Caption("Do kontrahenta")]
			public IPodmiotKasowy Do
			{
				get { return dok; }
				set
				{
					dok = value;
					OnChanged();
				}
			}


			[Priority(170)]
			[Caption(wgWartościLabel)]
			[Browsable(wgWartościLabel != "")]
			[Dictionary(wgWartościDictionary)]
			public String WartośćCechy
			{
				get { return wartośćCechy; }
				set
				{
					wartośćCechy = value;
					OnChanged();
				}
			}


			public Boolean IsReadOnlyWartośćCechy()
			{ return wgWartościCechy == "" || zakres != Zakres.Kontrahenci; }


			[Priority(180)]
			public TypDokumentow Dokumenty
			{
				get { return dokumenty; }
				set
				{
					dokumenty = value;
					OnChanged();
				}
			}


			[Priority(190)]
			[Caption("Rodzaj")]
			public RodzajDokumentów Rodzaj
			{
				get { return rodzaj; }
				set
				{
					rodzaj = value;
					OnChanged();
				}
			}


			[Priority(200)]
			[Caption("Wg wartości PLNHist")]
			public Boolean WgWartosciPLNHist
			{
				get { return wgWartosciPLNHist; }
				set
				{
					wgWartosciPLNHist = value;
					OnChanged();
				}
			}


			[Priority(210)]
			public Waluta Waluta
			{
				get { return waluta; }
				set
				{
					waluta = value;
					OnChanged();
				}
			}


			[Priority(220)]
			public String AktualneKonto
			{
				get { return aktualneKonto; }
				set
				{
					aktualneKonto = value.ToUpper();
					OnChanged();
				}
			}
		}


		[Context(Required = true)]
		public PrnParams Params
		{
			get { return pars; }
			set { pars = value; }
		}


        [Context(Required = true)]
	    public WydrukOddzialParams OParams { get; set; }




		//
		// WERYFIKATOR WALUTY
		//


		public class WeryfikatorWaluty : Verifier
		{
			readonly PrnParams data;
			bool active = false;

			public WeryfikatorWaluty(PrnParams data)
			{ this.data = data; }

			public override VerifierType Type
			{ get { return VerifierType.Error; } }

			public override String Description
			{ get { return "Podaj walutę jeśli zestawienie nie jest robione wg wartości PLNHist."; } }

			protected override Boolean IsValid()
			{ return data.Waluta != null || data.WgWartosciPLNHist; }

			public override Object Source
			{ get { return this.data; } }

			protected override bool IsAccept(object data, string property, VerifierAction action)
			{
				if (action == VerifierAction.AcceptRow) active = true;
				return active && data == this.data && property == "Waluta";
			}

			public override bool Equals(object v)
			{ return GetType() == v.GetType() && data == ((WeryfikatorWaluty)v).data; }

			public override int GetHashCode()
			{ return data.GetHashCode(); }
		}


		//
		// LOCAL VARIABLES
		//


		private PrnParams pars = null;
		private WydrukiRozrachunkowFiltr wr = new WydrukiRozrachunkowFiltr();

	


		//
		// PODSUMOWANIE (wiersz zestawienia)
		//


		private class Podsumowanie
		{
			private readonly PrnParams prms;

			private Decimal razem;
			private Decimal biezace;
			private Decimal przeterminowane;
			private Decimal[] zaleglosci = new Decimal[okresy.Length + 1];


			public Podsumowanie(PrnParams prms)
			{
				this.prms = prms;
			}


			public void Add(RozrachunekIdx idx, StanRozliczeniaRozrachunkuWorker srrWorker)
			{
				int zwłoka;
				Currency kwotaZob;
				Currency kwotaNal;

				if (prms.TypRozliczen == TypRozliczen.Kasowe)
				{
					zwłoka = idx.ZwłokaNaDzień(prms.Aktualny);

					kwotaZob = prms.WgWartosciPLNHist ? srrWorker.ZobowiazaniePLNHist(prms.Aktualny) : srrWorker.Zobowiazanie(prms.Aktualny);
					kwotaNal = prms.WgWartosciPLNHist ? srrWorker.NaleznoscPLNHist(prms.Aktualny) : srrWorker.Naleznosc(prms.Aktualny);
				}
				else
				{
					zwłoka = idx.ZwłokaKsiNaDzień(prms.Aktualny);

					kwotaZob = prms.WgWartosciPLNHist ? srrWorker.ZobowiazanieKsi(prms.Aktualny) : srrWorker.ZobowiazanieKsiOpe(prms.Aktualny);
					kwotaNal = prms.WgWartosciPLNHist ? srrWorker.NaleznoscKsi(prms.Aktualny) : srrWorker.NaleznoscKsiOpe(prms.Aktualny);
				}

				switch (prms.Dokumenty)
				{
					case TypDokumentow.Należności:
						dodaj(kwotaNal.Value, zwłoka);
						break;

					case TypDokumentow.Zobowiązania:
						dodaj(kwotaZob.Value, zwłoka);
						break;

					default:
						dodaj(kwotaNal.Value - kwotaZob.Value, zwłoka);
						break;
				}
			}


			private void dodaj(Decimal kwota, int zwloka)
			{
				razem += kwota;

				if (zwloka == 0)
					biezace += kwota;
				else
				{
					przeterminowane += kwota;
					for (int i = 0; i < okresy.Length; i++)
						if (zwloka <= okresy[i])
						{
							zaleglosci[i] += kwota;
							return;
						}
					zaleglosci[okresy.Length] += kwota;
				}
			}


			public Decimal Razem
			{ get { return razem; } }

			public Decimal Biezace
			{ get { return biezace; } }

			public Decimal Przeterminowane
			{ get { return przeterminowane; } }

			public Decimal[] Zaleglosci
			{ get { return zaleglosci; } }
		}

		
		//
		// USTAWIANIE DANYCH WIERSZA
		//


		void Grid1_BeforeRow(object sender, RowEventArgs args)
		{
			Podsumowanie row = (Podsumowanie)args.Row;
			for (int i = 0; i <= okresy.Length; i++)
				Grid1.Columns[3 + i].EditValue = row.Zaleglosci[i];
		}


		//
		// LOAD
		//


		void OnContextLoad(object sender, EventArgs e)
		{
			//
			// -> kolumny dynamiczne zgodnie w podziałem stref
			//

			for (int i = 0; i <= okresy.Length; i++)
			{
				GridColumn nowa = new GridColumn();
				Grid1.Columns.Add(nowa);
				if (i == 0)
					nowa.Caption = "Przeterminowane~Od 1 do " + okresy[i] + " dni";
				else if (i == okresy.Length)
					nowa.Caption = "Przeterminowane~Ponad " + okresy[i - 1] + " dni";
				else
					nowa.Caption = "Przeterminowane~Od " + (okresy[i - 1] + 1) + " do " + okresy[i] + " dni";

				nowa.Align = HorizontalAlign.Right;
				nowa.Format = "{0:n}";
				nowa.Total = Total.Sum;
				nowa.HideZero = true;
				nowa.Width = 12;
			}

			wr.PodmiotOd = pars.Od;
			wr.PodmiotDo = pars.Do;
		    wr.TypRozliczenKsiegowy = pars.TypRozliczen == TypRozliczen.Księgowe;
			wr.Waluta = pars.Waluta;
			wr.SetAktualneKonto(pars.AktualneKonto, pars.Aktualny);
			wr.SetFeature(wgWartościCechy, pars.WartośćCechy);

			//
			// NAGŁÓWEK RAPORTU
			//

			
            ReportHeader1["ODDZIAL"] = OParams.GetTitleItem();
			ReportHeader1["TYPROZLICZEN"] = pars.TypRozliczen == TypRozliczen.Kasowe ? "kasowych" : "księgowych";
			ReportHeader1["TYP"] = pars.Dokumenty == TypDokumentow.PerSaldo ? "per saldo" : (pars.Dokumenty == TypDokumentow.Należności ? "należności" : "zobowiązań");
			ReportHeader1["RODZAJ"] = pars.Rodzaj == RodzajDokumentów.Razem ? String.Empty : "|Rodzaj: <STRONG>" + pars.Rodzaj + "</STRONG>";
			ReportHeader1["ZAKRES"] = pars.Zakres == Zakres.Razem ? String.Empty : "|Zakres: <STRONG>" + pars.Zakres + "</STRONG>";
			ReportHeader1["WGCECHY"] = pars.Zakres != Zakres.Kontrahenci || pars.WartośćCechy == String.Empty ? String.Empty : String.Format("|</STRONG>{0}: <STRONG> {1}", wgWartościCechy, pars.WartośćCechy);
			ReportHeader1["KONTRAHENT"] = wr.GetTitleStringPodmiot();
			ReportHeader1["KONTO"] = wr.GetTitleStringKonto();
			ReportHeader1["WALUTA"] = wr.GetTitleStringWaluta(pars.WgWartosciPLNHist);
		

			//
			// QUERY
			//

				KasaModule kasa = KasaModule.GetInstance(dc);
				Soneta.Business.View view;


				if (pars.TypRozliczen == TypRozliczen.Kasowe)
				{
					//
					// -> rozliczenia kasowe:
					// - rachunki nierozliczone na dzień aktualności
					// - z odpowiednim okresem wystawienia
					// - z odpowiednim okresem księgowania
					//

					view = kasa.RozrachunkiIdx.Nierozliczone(null, pars.Okres, pars.Aktualny);

					if (pars.OkresKS != FromTo.All)
						view.Condition &= new FieldCondition.Contain("DataKsiegowania", pars.OkresKS);
				}
				else
				{
					//
					// -> rozliczenia księgowe:
					// - bez ograniczenia na rozliczenie kasowe
					// - odpowiednik wyszukiwania na widoku rozliczeń KS niezaksięgowanych
					//

					view = kasa.RozrachunkiIdx.CreateView();
					view.Condition = new FieldCondition.Contain("DataKsiegowania", pars.OkresKS * new FromTo(Date.MinValid + 1, Date.MaxValid - 1));

					if (pars.Okres != FromTo.All)
						view.Condition &= new FieldCondition.Contain("Data", pars.Okres);

					view.Condition &= new FieldCondition.Greater("DataOstatniegoKsi", pars.Aktualny) | new FieldCondition.Equal("DataRozliczenia", Date.MaxValue);
				}

				view.Condition &= zakresCondition();
				view.Condition &= rodzajCondition(kasa.RozrachunkiIdx);
            	view.Condition &= OParams.GetConditionIdx();

				StanRozliczeniaRozrachunkuWorker workerSrr = new StanRozliczeniaRozrachunkuWorker();
				workerSrr.StanRozliczenia = StanRozliczeniaRozrachunku.Nierozliczone;
				workerSrr.StanRozliczeniaKs = StanRozliczeniaRozrachunku.Nierozliczone;

				Podsumowanie pds = new Podsumowanie(pars);
				wr.SetFilter(view);

				foreach (RozrachunekIdx idx in view)
				{
					workerSrr.RozrachunekIdx = idx;
					pds.Add(idx, workerSrr);
				}

				Grid1.DataSource = new object[] { pds };
		}


		//
		// FILTRY
		//


		private RowCondition zakresCondition()
		{
			switch (pars.Zakres)
			{
				case Zakres.Kontrahenci:
					return new FieldCondition.TypeOf("Podmiot", typeof(Soneta.CRM.Kontrahent));

				case Zakres.Pracownicy:
					return new FieldCondition.TypeOf("Podmiot", typeof(Soneta.Kadry.Pracownik));

				case Zakres.Urzędy:
					RowCondition condition = RowCondition.Empty;
					condition = new FieldCondition.TypeOf("Podmiot", typeof(Soneta.CRM.Kontrahent));
					condition |= new FieldCondition.TypeOf("Podmiot", typeof(Soneta.Kadry.Pracownik));
					return new RowCondition.Not(condition);

				default:
					return RowCondition.Empty;
			}
		}


		private RowCondition rodzajCondition(RozrachunkiIdx idxTable)
		{
			Boolean fNaleznosci = pars.Dokumenty != TypDokumentow.Zobowiązania;
			Boolean fZobowiazania = pars.Dokumenty != TypDokumentow.Należności;
			Boolean fZaplaty = pars.Rodzaj != RodzajDokumentów.Płatności;
			Boolean fPlatnosci = pars.Rodzaj != RodzajDokumentów.Zapłaty;

			return idxTable.ZakresEx(fNaleznosci && fPlatnosci, fZobowiazania && fPlatnosci, fZobowiazania && fZaplaty, fNaleznosci && fZaplaty);
		}

		
		//
		// Zarzadzanie kontekstem
		//


		private WydrukiRozrachunkowSessionProxy sProxy = null;


		private void OnContextLoading(Object sender, EventArgs args)
		{
			sProxy = WydrukiRozrachunkowSessionProxy.GetSingleDbInstance(dc.Context);
			dc.attachContext(sProxy.CloneContext(dc.Context));
		}


		protected override void OnUnload(EventArgs e)
		{
			WydrukiRozrachunkowSessionProxy.SmartDispose(ref sProxy);
			base.OnUnload(e);
		}
	
	
    </script>
</head>
<body>
	<form id="StrukturaWiekowaNaleznosciZestawienie" method="post" runat="server">
	<ea:DataContext ID="dc" runat="server" Landscape="False" OnContextLoad="OnContextLoad" OnContextLoading="OnContextLoading" />

	<cc1:ReportHeader ID="ReportHeader1" runat="server" ContextTypeName="Soneta.Business.OkresContext,Soneta.Business" DataMember0="Okres" DataMember1="Aktualny" DataMember2="OkresKS"
		Title="Struktura wiekowa %TYP% - zestawienie|%ODDZIAL%</STRONG>Stan na dzień: <STRONG>{1}</STRONG>|Wg rozliczeń: <STRONG>%TYPROZLICZEN%</STRONG>| Za okres: <STRONG>{0}</STRONG>| Za okres KS: <STRONG>{2}</STRONG>%RODZAJ%%ZAKRES%%WGCECHY%%KONTRAHENT%%WALUTA%%KONTO%"
		/>

	<ea:SectionMarker ID="SectionMarker2" runat="server" />
	<ea:Grid ID="Grid1" runat="server" OnBeforeRow="Grid1_BeforeRow">
		<Columns>
			<ea:GridColumn runat="server" Width="12" Align="Right" DataMember="Razem" Caption="Razem" HideZero="True" Format="{0:n}" />
			<ea:GridColumn runat="server" Align="Right" DataMember="Biezace" Caption="Bieżące" HideZero="True" Format="{0:n}" />
			<ea:GridColumn runat="server" Width="12" Align="Right" DataMember="Przeterminowane" Caption="Przeterminowane~Razem" HideZero="True" Format="{0:n}" />
		</Columns>
	</ea:Grid>

	<ea:SectionMarker ID="SectionMarker3" runat="server" SectionType="Footer" />
	<cc1:ReportFooter ID="ReportFooter1" runat="server">
		<Subtitles>
			<cc1:FooterSubtitle ID="FooterSubtitle1" runat="server" SubtitleType="Operator" />
			<cc1:FooterSubtitle ID="FooterSubtitle2" runat="server" Caption="Sporządził" SubtitleType="Podpis" />
			<cc1:FooterSubtitle ID="FooterSubtitle3" runat="server" Caption="Sprawdził" SubtitleType="Podpis" />
			<cc1:FooterSubtitle ID="FooterSubtitle4" runat="server" Caption="Zatwierdził" SubtitleType="Podpis" />
		</Subtitles>
	</cc1:ReportFooter>
	</form>
</body>
</html>

